<?php

namespace App\Exceptions;

use Illuminate\Auth\AuthenticationException;
use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Illuminate\Validation\ValidationException;
use Symfony\Component\HttpKernel\Exception\HttpException;
use Symfony\Component\HttpKernel\Exception\UnprocessableEntityHttpException;
use Throwable;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;

class Handler extends ExceptionHandler
{
    /**
     * The list of the inputs that are never flashed to the session on validation exceptions.
     *
     * @var array<int, string>
     */
    protected $dontFlash = [
        'current_password',
        'password',
        'password_confirmation',
    ];

    /**
     * Register the exception handling callbacks for the application.
     */
    public function register(): void
    {
        $this->renderable(function (HttpException $e, $request) {
            if ($request->is('api/*')) {
                $message = $e->getMessage();

                $stackTrace = config('app.debug') ? $e->getTrace() : [];

                $response = [
                    'success' => false,
                    'message' => $message,
                    'error' => $e->getMessage()
                ];

                if (config('app.debug')) {
                    $response['stack_trace'] = $stackTrace;
                }

                return response()->json($response, $e->getStatusCode());
            }
        });

        $this->renderable(function (NotFoundHttpException $e, $request) {
            //
            if ($request->is('api/*')) {
                return response()->json([
                    'success' => false,
                    'message' => 'Resource not found',
                    'error' => $e->getMessage()
                ], 404);
            }

        });

        $this->renderable(function (ValidationException $e, $request) {
            //
            if ($request->is('api/*')) {

                $errors = [];
                foreach ($e->errors() as $key => $value) {
                    $errors[] = $value;
                }

                //flatten the array
                $errors = array_merge(...$errors);

                return response()->json([
                    'success' => false,
                    'message' => 'Validation error',
                    'errors' => $errors
                ], 422);
            }

        });

        $this->renderable(function (AuthenticationException $e, $request) {
            //
            if ($request->is('api/*')) {
                return response()->json([
                    'success' => false,
                    'message' => 'Unauthorized'
                ], 401);
            }

        });
    }
}