<?php

namespace App\Http\Controllers;

use App\Models\Bank;
use Illuminate\Http\Request;

class BankController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $banks = Bank::all();

        return response()->json([
            'success' => true,
            'data' => $banks,
        ], 200);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $rules = [
            'bank_name' => 'required|string',
            'account_alias' => 'required|string',
            'card_number' => 'nullable|string',
            'account_number' => 'nullable|string',
            'interbank_key' => 'nullable|string',
        ];

        $validator = \Validator::make($request->input(), $rules);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => 'Validation error',
                'errors' => $validator->errors()
            ], 400);
        }

        $data = $validator->validated();


        $banls = Bank::create($data);

        return response()->json([
            'success' => true,
            'data' => $banls,
        ], 201);
    }

    /**
     * Display the specified resource.
     */
    public function show(Bank $bank)
    {
        return response()->json([
            'success' => true,
            'data' => $bank,
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Bank $bank)
    {
        $rules = [
            'bank_name' => 'required|string',
            'account_alias' => 'required|string',
            'card_number' => 'nullable|string',
            'account_number' => 'nullable|string',
            'interbank_key' => 'nullable|string',
        ];
        $validator = \Validator::make($request->input(), $rules);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => 'Validation error',
                'errors' => $validator->errors()
            ], 400);
        }

        $data = $validator->validated();

        $bank->update($data);

        return response()->json([
            'success' => true,
            'data' => $bank,
        ], 200);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Bank $bank)
    {
        $deleted = $bank->delete();
        $responseCode = $deleted ? 200 : 404;
        $message = $deleted ? 'Bank deleted' : 'Bank not found';
        $success = $deleted ? true : false;

        return response()->json(
            [
                'success' => $success,
                "message" => $message,
                'data' => $bank,
            ],
            $responseCode
        );
    }
}
