<?php

namespace App\Http\Controllers;

use App\Models\Customer;
use Illuminate\Http\Request;

class CustomerController extends Controller
{

    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $rules = [
            "created_by" => "nullable|exists:users,id",
        ];
        $validator = \Validator::make(request()->query(), $rules);

        $data = $validator->validated();

        $customer_query = Customer::query();
        if (isset($data['created_by'])) {
            $customer_query->where('created_by', $data['created_by']);
        }
        $customers = $customer_query->get()->load([
            'pricetype', 'user', 'favoriteProducts'
        ]);

        return response()->json([
            'success' => true,
            'data' => $customers,
        ], 200);
        // $customer = Customer::all()->load(['pricetype', 'user']);
        // return response()->json([
        //     'success' => true,
        //     'data' => $customer,
        // ], 200);
    }

    public function indexPublic()
    {
        $rules = [
            "created_by" => "nullable|exists:users,id",
        ];
        $validator = \Validator::make(request()->query(), $rules);

        $data = $validator->validated();

        $customer_query = Customer::query();
        if (isset($data['created_by'])) {
            $customer_query->where('created_by', $data['created_by']);
        }
        $customers = $customer_query->get()->load([
            'pricetype', 'user'
        ]);

        return response()->json([
            'success' => true,
            'data' => $customers,
        ], 200);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $rules = [
            'name' => 'required|string',
            'phone_number' => 'string',
            'address' => 'string',
            'pricetype_id' => 'nullable|exists:pricetypes,id',
            'has_credit' => 'boolean',
            'created_by' => 'nullable|exists:users,id'
        ];

        $validator = \Validator::make($request->input(), $rules);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => 'Validation error',
                'errors' => $validator->errors()
            ], 400);
        }

        $data = $validator->validated();


        $customers = Customer::create($data);

        return response()->json([
            'success' => true,
            'data' => $customers,
        ], 201);
    }

    public function storePublic(Request $request)
    {
        $rules = [
            'name' => 'required|string',
            'phone_number' => 'string',
            'address' => 'string',
            'pricetype_id' => 'nullable|exists:pricetypes,id',
            'has_credit' => 'nullable|boolean',
            'created_by' => 'nullable|exists:users,id'
        ];

        $validator = \Validator::make($request->input(), $rules);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => 'Validation error',
                'errors' => $validator->errors()
            ], 400);
        }

        $data = $validator->validated();


        $customers = Customer::create($data);

        return response()->json([
            'success' => true,
            'data' => $customers,
        ], 201);
    }

    /**
     * Display the specified resource.
     */
    public function show(Customer $customer)
    {
        $customer->load('pricetype');
        return response()->json([
            'success' => true,
            'data' => $customer,
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Customer $customer)
    {
        $rules = [
            'name' => 'required|string',
            'phone_number' => 'string',
            'address' => 'string',
            'pricetype_id' => 'nullable|exists:pricetypes,id',
            'has_credit' => 'boolean',
            'created_by' => 'nullable|exists:users,id'
        ];

        $validator = \Validator::make($request->input(), $rules);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => 'Validation error',
                'errors' => $validator->errors()
            ], 400);
        }

        $data = $validator->validated();

        $customer->update($data);

        return response()->json([
            'success' => true,
            'data' => $customer,
        ], 200);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Customer $customer)
    {
        $deleted = $customer->delete();
        $responseCode = $deleted ? 200 : 404;
        $message = $deleted ? 'Customer deleted' : 'Customer not found';
        $success = $deleted ? true : false;

        return response()->json(
            [
                'success' => $success,
                "message" => $message,
                'data' => $customer,
            ],
            $responseCode
        );
    }
}
