<?php

namespace App\Http\Controllers;

use App\Models\Subcategory;
use Illuminate\Http\Request;

class SubcategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {

        $subcategories = Subcategory::all();

        return response()->json([
            'success' => true,
            'data' => $subcategories
        ], 200);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $rules = [
            'name' => 'required|string',
            'category_id' => 'nullable|exists:categories,id',
        ];

        $validator = \Validator::make($request->input(), $rules);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => 'Validation error',
                'errors' => $validator->errors()
            ], 400);
        }

        $data = $validator->validated();

        $subcategory = Subcategory::create($data);

        return response()->json([
            'success' => true,
            'data' => $subcategory
        ], 201);
    }

    /**
     * Display the specified resource.
     */
    public function show(Subcategory $subcategory)
    {
        $subcategory->load('category');
        return response()->json([
            'success' => true,
            'data' => $subcategory
        ], 200);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Subcategory $subcategory)
    {
        $rules = [
            'name' => 'required|string',
            'category_id' => 'nullable|exists:categories,id',
        ];
        $validator = \Validator::make($request->input(), $rules);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => 'Validation error',
                'errors' => $validator->errors()
            ], 400);
        }

        $data = $validator->validated();

        $subcategory->update($data);

        return response()->json([
            'success' => true,
            'data' => $subcategory
        ], 200);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Subcategory $subcategory)
    {
        $deleted = $subcategory->delete();
        $responseCode = $deleted ? 200 : 404;
        $message = $deleted ? 'Subcategory deleted' : 'Subcategory not found';
        $success = $deleted ? true : false;

        return response()->json(
            [
                'success' => $success,
                "message" => $message,
                'data' => $subcategory,
            ],
            $responseCode
        );
    }
}