<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Coupon extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $fillable = [
        'code',
        'type',
        'value',
        'use_limit',
        'used',
        'expires_at',
        'status',
        'createdBy',
        'updatedBy',
    ];

    protected $dates = [
        'expires_at',
    ];

    public function createdBy()
    {
        return $this->belongsTo(User::class, 'createdBy');
    }

    public function updatedBy()
    {
        return $this->belongsTo(User::class, 'updatedBy');
    }

    public function sales()
    {
        return $this->hasMany(Sale::class);
    }



}
