<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Sale_detail extends Model
{
    use HasFactory;
    protected $fillable = [
        'product_id',
        'sale_id',
        'quantity',
        'total',
        'cart_item',
        'stock_id',
        'size_id'
    ];
    public function sale()
    {
        return $this->belongsTo(Sale::class);
    }
    public function stock()
    {
        return $this->belongsTo(Stock::class);
    }
    public function product()
    {
        return $this->belongsTo(Product::class);
    }
    public function size()
    {
        return $this->belongsTo(Size::class);
    }
}
