<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('sales', function (Blueprint $table) {
            $table->enum('sale_category', ['purchase', 'quotation', 'layaway'])->default('purchase')->after('bank_id');
            $table->enum('status', ['pending', 'paid', 'cancelled'])->default('pending')->after('sale_category');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('sales', function (Blueprint $table) {
            $table->dropColumn('sale_category');
            $table->dropColumn('status');
        });
    }
};
