<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Route::get(
    '/generate-pdf',
    [\App\Http\Controllers\PDFController::class, 'generateHtmlToPDF']
);

Route::get(
    '/generate-pdf-view',
    function () {
        $query = \App\Models\Product::with(['files', 'stocks']);

        if (request()->has('category_id')) {
            $query->where('category_id', request('category_id'));
        }

        if (request()->has('subcategory_id')) {
            $query->where('subcategory_id', request('subcategory_id'));
        }

        // where has at least one file
        $query->whereHas('files');
        $data['products'] = $query->get();
        return view('product-peer-page', $data);
    }
);
