<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Document</title>
    <style>
        .page-break {
            page-break-before: always;
        }

        body {
            background: url(<?php echo e('data:image/webp;base64,' . base64_encode(file_get_contents(public_path('/assets/logo.png')))); ?>);
            background-size: 200px auto;
            background-repeat: no-repeat;
            background-attachment: fixed;
            background-position: center;
        }

        .image-container {
            position: relative;
            width: 100%;
            border-radius: 20px;
            overflow: hidden;
        }

        .image-container img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .image-container .title {
            position: absolute;
            top: 10px;
            left: 30px;
            background: white;
            padding: 0 10px;
            border-radius: 10px;
        }

        .water-mark {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: url(<?php echo e('data:image/webp;base64,' . base64_encode(file_get_contents(public_path('/assets/logo.png')))); ?>);
            background-size: 100px auto;
            background-repeat: repeat;
            opacity: 0.1;
        }
    </style>
</head>

<body>
    <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="page-break">
            <?php if($product['files']->count() > 0): ?>
                <div class="image-container">
                    <h1 class="title">COD-<?php echo e($product['name']); ?></h1>
                    <img src="storage/<?php echo e($product['files'][0]['path']); ?>" alt="<?php echo e($product['name']); ?>">
                    <div class="water-mark"></div>
                </div>
            <?php endif; ?>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</body>

</html>
<?php /**PATH /home/franco/workspaces/cactuslabs/ramadiApi/resources/views/product-peer-page.blade.php ENDPATH**/ ?>